/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: PrefixMap.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml;

import java.util.*;

/**
 * Like Attribute, this class is immutable for similar reasons
 */
public class PrefixMap {
    Hashtable prefixMap;
    Hashtable namespaceMap;

    /**
     * Constructor declaration
     *
     *
     * @see
     */
    public PrefixMap() {
	prefixMap = new Hashtable();
	namespaceMap = new Hashtable();
    }

    /**
     * Constructor declaration
     *
     *
     * @param base
     * @param prefix
     * @param namespace
     *
     * @see
     */
    public PrefixMap(PrefixMap base, String prefix, String namespace) {
	prefixMap = clone(base.prefixMap);
	namespaceMap = clone(base.prefixMap);

	if (namespace == null) {
	    namespace = "";
	} 

	String oldNS = (String) prefixMap.get(prefix);

	if (oldNS == null) {
	    oldNS = "";
	} 

	if (!namespace.equals(oldNS)) {
	    if (prefix.equals(namespaceMap.get(oldNS))) {
		namespaceMap.remove(oldNS);
	    } 

	    prefixMap.put(prefix, namespace);
	    namespaceMap.put(namespace, prefix);
	} 
    }

    /**
     * Method declaration
     *
     *
     * @param original
     *
     * @return
     *
     * @see
     */
    private static Hashtable clone(Hashtable original) {
	Hashtable copy = new Hashtable(original.size() + 1);

	for (Enumeration e = original.keys(); e.hasMoreElements(); ) {
	    Object key = e.nextElement();

	    copy.put(key, original.get(key));
	} 

	return copy;
    } 

    /**
     * Method declaration
     *
     *
     * @param prefix
     *
     * @return
     *
     * @see
     */
    public String getNamespace(String prefix) {
	return (String) prefixMap.get(prefix);
    } 

    /**
     * Method declaration
     *
     *
     * @param namespace
     *
     * @return
     *
     * @see
     */
    public String getPrefix(String namespace) {
	return (String) namespaceMap.get(namespace == null ? "" : namespace);
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public Enumeration prefixEnumeration() {
	return prefixMap.keys();
    } 

}

